<?php

/** @var \Laravel\Lumen\Routing\Router $router */


/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

function uri_resource($router, $uri, $controller)
{
    $router->get($uri, $controller . '@index');
    $router->post($uri, $controller . '@store');
    $router->get($uri . '/{id}', $controller . '@show');
    $router->put($uri . '/{id}', $controller . '@update');
    $router->delete($uri . '/{id}', $controller . '@destroy');
}

$router->get('/', function () use ($router) {
    return "AKPER.PASAR.REBO-API";
});

$router->group(['prefix' => 'api'], function ($router) {
    
    $router->get('/', function () {
        return "AKPER.PASAR.REBO-API";
    });

    $router->group(['prefix' => 'auth'], function ($router) {
        
        $router->get('/', 'AuthController@index');
        $router->post('login', 'AuthController@login');


        $router->group(['middleware' => 'auth'], function ($router) {
            $router->get('me', 'AuthController@me');
            $router->post('logout', 'AuthController@logout');
            $router->post('refresh', 'AuthController@refresh');
            $router->put('update-password/{username}', 'AuthController@updatePassword');
        });        
    });   
    
    $router->get('group-role/{group_id}', 'GroupAksesModulController@get_role');
    $router->get('group-role-button/{group_id}/{modul_id}', 'MenuUtamaFungsiController@get_role_button');
    $router->post('groupaksesmodul-update/{group_id}', 'GroupAksesModulController@update_role');
    $router->get('groupakses-except', 'GroupAksesController@index2');
    
    uri_resource($router, 'identitas', 'IdentitasController');
    uri_resource($router, 'sosmed', 'SosmedController');
    uri_resource($router, 'breadcum', 'BreadcumController');
    uri_resource($router, 'identitaswebsite', 'IdentitasWebsiteController');
    
    uri_resource($router, 'profile', 'ProfileController');
    $router->get('cariprofileakses/{levelAkses}', 'ProfileController@CariProfileAkses');

    uri_resource($router, 'mahasiswa', 'MahasiswaController');
    uri_resource($router, 'dosen', 'DosenController');
    
    uri_resource($router, 'agama', 'AgamaController');
    uri_resource($router, 'kelurahan', 'KelurahanController');
    uri_resource($router, 'kecamatan', 'KecamatanController');
    uri_resource($router, 'kabupaten', 'KabupatenController');
    uri_resource($router, 'provinsi', 'ProvinsiController');
    
    uri_resource($router, 'transkripnilai', 'TranskripNilaiController');
    
    // $router->group(['prefix' => 'krs'], function ($router) {
    //     $router->get('{nim}', 'KrsController@show');
    // });
    
    uri_resource($router, 'krs', 'KrsController');
    uri_resource($router, 'prodi', 'ProdiController');
    uri_resource($router, 'jadwalkuliah', 'JadwalKuliahController');
    uri_resource($router, 'jadwalujian', 'JadwalUjianController');
    uri_resource($router, 'kelaskuliah', 'KelasKuliahController');
    uri_resource($router, 'matakuliah', 'MataKuliahController');
    uri_resource($router, 'biayakuliah', 'BiayaKuliahController');
    uri_resource($router, 'notif', 'NotifController');
    $router->get('bayarbiayakuliah/{namaUser}', 'BiayaKuliahController@BayarBiayaKuliah');
    $router->get('showJumlahTagihan/{namaUser}', 'BiayaKuliahController@showJumlahTagihan');
    // SisaBiayaKuliah
    $router->get('SisaBiayaKuliah/{namaUser}', 'BiayaKuliahController@SisaBiayaKuliah');
    // uri_resource($router, 'komponenbiayakuliah', 'KomponenBiayaKuliahController');
    $router->get('komponenbiayakuliah/{kd_biaya}/{kd_tahun_ajar}/{kd_semester}/{kd_jurusan}', 'KomponenBiayaKuliahController@get_komponen');
    $router->get('pembimbingakademik/{namaUser}', 'PembimbingPejabatAkademikController@PembimbingAkademik');
    $router->get('pejabatakademik', 'PembimbingPejabatAkademikController@PejabatAkademik');
    
    $router->post('/save-fcm-token', 'UserController@saveFcmToken');
    
    //api mobile apps & web
    uri_resource($router, 'updatepassword', 'UpdatePasswordController');
    uri_resource($router, 'presensimahasiswa', 'PresensiMahasiswaController');
    
    //syarat cetak
    $router->get('syaratcetak/{kd_komponen}/{kd_jurusan}/{kd_tahun_ajar}/{kd_semester}', 'SyaratCetakController@SyaratCetak');
    
    //cek version app
    uri_resource($router, 'checkversionapp', 'CekVersionAppController');
    
    //InfoAkademik
    uri_resource($router, 'pengumuman', 'PengumumanController');
    
    //evaluasi akadmeik
    $router->get('listdosen/{nim}', 'EvaluasiAkademikController@ListDosen');
    $router->get('listmatakuliah/{kd_matakuliah}', 'EvaluasiAkademikController@ListMatakuliah');
    $router->get('listpenilaian/{nim}/{id_kuesioner}', 'EvaluasiAkademikController@ListPenilaian');
    $router->get('listkuesioner/{id_kategori}', 'EvaluasiAkademikController@ListKuesioner');
    $router->post('evaluasiakademik', 'EvaluasiAkademikController@store');
    
    //materi perkuliahan
    uri_resource($router, 'materiperkuliahan', 'MateriPerkuliahanController');
    
    //identitas kaprodi
    uri_resource($router, 'identitaskaprodi', 'KaprodiController');
});
