<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('event_id');
            $table->string('event_detail_name');
            $table->bigInteger('vendor_id');

            $table->integer('guest_id');            
            $table->string('guest_description')->nullable();

            $table->string('place_of_order_id');
            $table->string('place_of_order_name');
            $table->bigInteger('customer_id');
            $table->string('customer_name');
            $table->bigInteger('customer_head1_id');
            $table->string('customer_head1_name');
            $table->bigInteger('customer_head2_id');
            $table->string('customer_head2_name');

            $table->bigInteger('place_of_delivery_order_id');
            $table->string('place_of_delivery_order_name')->nullable();            

            $table->date('delivery_order_date');
            $table->date('transaction_date');

            $table->decimal('total_price', 20, 2)->default(0);

            $table->string('description_order')->nullable();
            $table->string('description_serve')->nullable();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();
            
            $table->timestamps();
        });

        Schema::create('order_details', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('order_id');
            $table->bigInteger('menu_id');
            $table->bigInteger('menu_serve_of_order_id');
            $table->string('detail_menu_name'); // free text. diisi detail saat diinput oleh pihak ruah tangga
            $table->integer('unit_id');
            $table->integer('qty');
            $table->decimal('price', 20, 2)->default(0);
            $table->decimal('total_price', 20, 2)->default(0);
            $table->integer('status')->default(1);

            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();            
            // $table->unique(['order_id', 'menu_id']);

            $table->timestamps();
        });

        Schema::create('statuses', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();            
        });
        
        Schema::create('order_statuses', function (Blueprint $table) {
            $table->id();
            $table->string('order_id');
            $table->string('status_id');
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();            
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
        Schema::dropIfExists('order_details');
        Schema::dropIfExists('statuses');
        Schema::dropIfExists('order_statuses');
    }
}
