<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TranskripNilai extends Model
{
    // Nama tabel dalam database
    protected $table = 't_nilai_khs';

    // Primary key dari tabel
    protected $primaryKey = 'nim'; // Sesuaikan dengan primary key pada tabel m_user

    // Kolom yang dapat diisi secara massal (mass assignment)
    protected $fillable = [
        'kd_jurusan',
        'kd_tahun_ajar',
        'kd_semester',
        'kd_kelas',
        'kd_matakuliah',
        'nim',
        'nilai_akhir',
        'nilai_indeks',
        'nilai_huruf',
        'nilai_bobot',
        'tanggal',
    ];

    // Kolom yang disembunyikan dalam array atau JSON output
    protected $hidden = [];

    // Menonaktifkan timestamps jika tabel tidak memiliki kolom created_at dan updated_at
    public $timestamps = false;
    
    public function mahasiswa()
    {
        return $this->belongsTo(Mahasiswa::class, 'nim', 'nim');
    }
    
    public function jurusan()
    {
        return $this->belongsTo(Jurusan::class, 'kd_jurusan', 'kd_jurusan');
    }
    
    public function tahun_ajar()
    {
        return $this->belongsTo(TahunAjar::class, 'kd_tahun_ajar', 'kd_tahun_ajar');
    }
    
    public function semester()
    {
        return $this->belongsTo(Semester::class, 'kd_semester', 'kd_semester');
    }
    
    public function kelas()
    {
        return $this->belongsTo(Kelas::class, 'kd_kelas', 'kode_kelas');
    }
    
    public function mata_kuliah()
    {
        return $this->belongsTo(MataKuliah::class, 'kd_matakuliah', 'kd_matakuliah');
    }
}
