<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SyaratCetak extends Model
{
    protected $table = 'm_syarat_adm_keu';
    protected $primaryKey = 'kd_syarat';
    public $timestamps = false;

    // Relasi ke Komponen
    public function komponen()
    {
        return $this->belongsTo(Komponen::class, 'kd_komponen', 'kd_komponen');
    }

    // Relasi ke Tahun Ajar
    public function tahunAjar()
    {
        return $this->belongsTo(TahunAjar::class, 'kd_tahun_ajar', 'kd_tahun_ajar');
    }

    // Relasi ke Semester
    public function semester()
    {
        return $this->belongsTo(Semester::class, 'kd_semester', 'kd_semester');
    }

    // Relasi ke Jurusan
    public function jurusan()
    {
        return $this->belongsTo(Jurusan::class, 'kd_jurusan', 'kd_jurusan');
    }
}
