<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Role extends Model
{
    public static function boot()
    {
        parent::boot();
        static::creating(function($model)
        {
            $user = auth()->user();
            $model->created_by = is_object($user) ? $user->id_user : 1;
            $model->updated_by = is_object($user) ? $user->id_user : 1;
        });
        static::updating(function($model)
        {
            $user = auth()->user();
            $model->updated_by = is_object($user) ? $user->id_user : 1;
        });
    }

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'slug', 'description', 'title', 'permissions'
    ];
    
    public static function dataCreate($data){
        self::unguard();
        $model = self::create($data);
        self::reguard();
        
        return $model;        
    }

    /**
     * The attributes that are used to populate all request inputs
     * @return array
     */
    public static function dataInput()
    {
        return [
            'slug', 'description', 'title', 'permissions'
        ];
    }

    public static function dataInputRules()
    {
        return [
            'title' => 'required',
            'slug' => 'required',
            // 'description' => 'required',
            'permissions' => 'required',
        ];
    }

    public static function dataUpdateRules($id)
    {
        return [
            'title' => 'required',
            // 'slug' => 'required',
            // 'description' => 'required',
            'permissions' => 'required',
        ];
    }
    public static function dataOutput($id)
    {
        return self::find($id);
    }


    public function users()
    {
        return $this->belongsToMany('App\Models\User')->orderBy('email')->withTimestamps();
    }

}
