<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notif extends Model 
{

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 't_notif';
    
    // Primary key dari tabel
    protected $primaryKey = 'nim'; // Sesuaikan dengan primary key pada tabel m_user

    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'id_user',
        'nim',
        'deskripsi',
        'status', 
    ];
    
    public static function dataInput()
    {
        return [
            'id_user',
            'nim',
            'deskripsi',
        ];
    }

    public static function dataUpdateRules($id)
    {
        return [
            'id_user' => 'required',
            'nim' => 'required',
        ];
    }

    public static function dataInputRules()
    {
        return [
            'id_user' => 'required',
            'nim' => 'required',
        ];
    }
    
    // Kolom yang disembunyikan dalam array atau JSON output
    protected $hidden = [];

    // Menonaktifkan timestamps jika tabel tidak memiliki kolom created_at dan updated_at
    public $timestamps = true;
}
