<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class KelasKuliah extends Model
{
    protected $table = 'm_kelas_detail';

    // Definisikan kolom yang dapat diisi secara massal (mass assignable)
    protected $fillable = ['kode_kelas', 'nim', 'kd_jurusan', 'kd_tahun_ajar', 'kd_semester'];

    // Jika Anda memiliki relasi, definisikan di sini
    public function jurusan()
    {
        return $this->belongsTo(Jurusan::class, 'kd_jurusan', 'kd_jurusan');
    }

    public function tahun_ajar()
    {
        return $this->belongsTo(TahunAjar::class, 'kd_tahun_ajar', 'kd_tahun_ajar');
    }

    public function semester()
    {
        return $this->belongsTo(Semester::class, 'kd_semester', 'kd_semester');
    }

    public function kelas()
    {
        return $this->belongsTo(Kelas::class, 'kd_kelas', 'kode_kelas');
    }

}
