<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class JadwalKuliah extends Model
{
    protected $table = 'jadwal_perkuliahan';

    // Definisikan kolom yang dapat diisi secara massal (mass assignable)
    protected $fillable = [
        'kd_jurusan', 'kd_tahun_ajar', 'kd_semester', 'kd_kelas', 'kd_matakuliah', 'kd_hari', 'jam','jam_selesai'
    ];

    // Jika Anda memiliki relasi, definisikan di sini
    public function jurusan()
    {
        return $this->belongsTo(Jurusan::class, 'kd_jurusan', 'kd_jurusan');
    }

    public function tahun_ajar()
    {
        return $this->belongsTo(TahunAjar::class, 'kd_tahun_ajar', 'kd_tahun_ajar');
    }

    public function semester()
    {
        return $this->belongsTo(Semester::class, 'kd_semester', 'kd_semester');
    }

    public function kelas()
    {
        return $this->belongsTo(Kelas::class, 'kd_kelas', 'kode_kelas');
    }
    
    public function kelaskuliah()
    {
        return $this->belongsTo(KelasKuliah::class, 'kd_kelas', 'kode_kelas');
    }
    
    public function matakuliah()
    {
        return $this->belongsTo(MataKuliah::class, 'kd_matakuliah', 'kd_matakuliah');
    }

}
