<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class EvaluasiAkademik extends Model
{
    protected $table = 't_jawaban_kuesioner_evaluasi';

    protected $fillable = [
        'id_m_kuesioner_evaluasi',
        'id_kategori',
        'id_t_kuesioner',
        'nidn',
        'kd_matakuliah',
        'jawaban',
        'tgl_jawab',
        'nim',
        'kd_tahun',
        'kd_semester',
        'kd_jurusan',
        'kd_kelas',
    ];
    
    public $timestamps = false;

    /**
     * Create a new record with the provided data.
     *
     * @param array $data
     * @return static
     */
    public static function dataCreate(array $data)
    {
        return self::create($data);
    }

    /**
     * List of input attributes for this model.
     *
     * @return array
     */
    public static function dataInput()
    {
        return [
            'id_m_kuesioner_evaluasi',
            'id_kategori',
            'id_t_kuesioner',
            'nidn',
            'kd_matakuliah',
            'jawaban',
            'tgl_jawab',
            'nim',
            'kd_tahun',
            'kd_semester',
            'kd_jurusan',
            'kd_kelas',
        ];
    }

    /**
     * Validation rules for creating a new record.
     *
     * @return array
     */
    public static function dataInputRules()
    {
        return [
            'id_m_kuesioner_evaluasi' => 'required|integer',
            'id_kategori' => 'required|integer',
            'id_t_kuesioner' => 'required|integer',
            'nidn' => 'required|string|max:20',
            'jawaban' => 'required|integer',
            'tgl_jawab' => 'required|date',
            'nim' => 'required|string|max:15',
            'kd_tahun' => 'required|integer',
            'kd_semester' => 'required|integer',
            'kd_jurusan' => 'required|integer',
            'kd_kelas' => 'required|string|max:8',
        ];
    }

    /**
     * Validation rules for updating an existing record.
     *
     * @param int $id
     * @return array
     */
    public static function dataUpdateRules($id)
    {
        return [
            'id_m_kuesioner_evaluasi' => 'sometimes|required|integer',
            'id_kategori' => 'sometimes|required|integer',
            'id_t_kuesioner' => 'sometimes|required|integer',
            'nidn' => 'sometimes|required|string|max:20',
            'jawaban' => 'sometimes|required|integer',
            'tgl_jawab' => 'sometimes|required|date',
            'nim' => 'sometimes|required|string|max:15',
            'kd_tahun' => 'sometimes|required|integer',
            'kd_semester' => 'sometimes|required|integer',
            'kd_jurusan' => 'sometimes|required|integer',
            'kd_kelas' => 'sometimes|required|string|max:8',
        ];
    }

    /**
     * Retrieve a single record by ID.
     *
     * @param int $id
     * @return static|null
     */
    public static function dataOutput($id)
    {
        return self::find($id);
    }
}
