<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CalonMahasiswa extends Model
{
    // Nama tabel dalam database
    protected $table = 'calon_mahasiswa';

    // Primary key dari tabel
    protected $primaryKey = 'uuid';

    // Primary key tidak auto increment
    public $incrementing = false;

    // Tipe data primary key
    protected $keyType = 'int';

    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'tanggal_registrasi',
        'uuid',
        'no_registrasi',
        'kd_gelombang',
        'kd_tahun_ajar',
        'kd_semester',
        'kd_jurusan',
        'kd_internal',
        'kategori_rekomendasi',
        'pemberi_rekomendasi',
        'nama_lengkap',
        'no_identitas',
        'nisn',
        'jenis_kelamin',
        'tempat_lahir',
        'tanggal_lahir',
        'kd_agama',
        'berat_badan',
        'tinggi_badan',
        'riwayat_penyakit',
        'alamat',
        'rt',
        'rw',
        'kd_kelurahan',
        'kd_kecamatan',
        'kd_kabkot',
        'kd_prov',
        'telepon1',
        'telepon2',
        'email',
        'nama_ibu',
        'asal_sekolah',
        'pekerjaan_ortu',
        'pendapatan_ortu',
        'fupload',
        'nama_orangtua_wali',
        'alamat_ortu',
        'rt_ortu',
        'rw_ortu',
        'kd_kelurahan_ortu',
        'kd_kecamatan_ortu',
        'kd_kabkot_ortu',
        'kd_prov_ortu',
        'telepon1_ortu',
        'spam',
    ];

    // Kolom yang disembunyikan dalam array atau JSON output
    protected $hidden = [
        'kategori_rekomendasi',
        'pemberi_rekomendasi',
        'riwayat_penyakit',
        'spam',
    ];

    // Menonaktifkan timestamps jika tabel tidak memiliki kolom created_at dan updated_at
    public $timestamps = false;

    /**
     * Define relationships to other models.
     */

    public function kd_agama()
    {
        return $this->belongsTo(Agama::class, 'kd_agama', 'kd_agama');
    }
    
    public function prodi()
    {
        return $this->belongsTo(Prodi::class, 'id_company', 'kd_jurusan');
    }

    public function kelurahan()
    {
        return $this->belongsTo(Kelurahan::class, 'kd_kelurahan', 'id_kelurahan');
    }

    public function kecamatan()
    {
        return $this->belongsTo(Kecamatan::class, 'kd_kecamatan', 'id_kecamatan');
    }

    public function kabupaten()
    {
        return $this->belongsTo(Kabupaten::class, 'kd_kabkot', 'id_kabupaten');
    }

    public function provinsi()
    {
        return $this->belongsTo(Provinsi::class, 'kd_prov', 'id_provinsi');
    }

    public function jurusan()
    {
        return $this->belongsTo(Jurusan::class, 'kd_jurusan', 'kd_jurusan');
    }
}
