<?php

namespace App\Http\Controllers;

use App\Models\TranskripNilai;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use Illuminate\Support\Facades\DB;

class TranskripNilaiController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function index(Request $request)
    {
        $transkripnilai = TranskripNilai::all();

        return response()->json($transkripnilai);
    }
    
    public function show($id)
    {
        // Menggunakan eager loading untuk memuat relasi yang diperlukan
        $transkripnilai = TranskripNilai::with(['mahasiswa', 'jurusan', 'tahun_ajar', 'semester', 'kelas', 'mata_kuliah'])
            ->where('nim', $id)
            ->get();
    
        if (!$transkripnilai) {
            return response()->json(['message' => 'Data not found'], 404);
        }
        
        return response()->json($transkripnilai);
    }
}
