<?php

namespace App\Http\Controllers;
use App\Models\SyaratCetak;
use Illuminate\Http\Request;
use DB; // Pastikan ini ditambahkan

class SyaratCetakController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }
    
    public function SyaratCetak($kd_komponen, $kd_jurusan, $kd_tahun_ajar, $kd_semester)
    {
        // Tambahkan fungsi formatKodeKomponen di dalam class
        function formatKodeKomponen(array $kodeKomponen): string {
            return implode(',', array_map(function($komponen) {
                return "'$komponen'";
            }, $kodeKomponen));
        }
    
        // Jika $kd_komponen adalah string yang berisi daftar kode dipisahkan koma, ubah menjadi array
        if (is_string($kd_komponen)) {
            $kd_komponen = explode(',', $kd_komponen);
        }
    
        // Format kode komponen
        $formattedKomponen = formatKodeKomponen($kd_komponen);
        // echo "Kode komponen terformat: $formattedKomponen";
    
        // Retrieve data berdasarkan query
        $syaratCetak = DB::table('m_syarat_adm_keu as a')
            ->select(
                'a.kd_syarat', 'a.kd_komponen', 'a.kd_tahun_ajar', 'a.kd_semester', 'a.kd_jurusan',
                'a.nilai', 'a.keterangan', 'a.tgl_mulai', 'a.tgl_selesai', 'b.komponen', 'c.tahun_ajar',
                'd.semester', 'e.jurusan'
            )
            ->join('m_komponen_nilai_matakuliah as b', function ($join) {
                $join->on('a.kd_komponen', '=', 'b.kd_komponen')
                     ->on('a.kd_jurusan', '=', 'b.kd_jurusan');
            })
            ->join('m_tahun_ajar as c', 'a.kd_tahun_ajar', '=', 'c.kd_tahun_ajar')
            ->join('m_semester as d', 'a.kd_semester', '=', 'd.kd_semester')
            ->join('m_jurusan as e', 'a.kd_jurusan', '=', 'e.kd_jurusan')
            ->whereRaw("a.kd_komponen IN ($formattedKomponen)") // Menggunakan whereRaw untuk IN clause
            ->where('a.kd_tahun_ajar', $kd_tahun_ajar)
            ->where('a.kd_semester', $kd_semester)
            ->where('a.kd_jurusan', $kd_jurusan)
            ->where('e.aktif', 'Y')
            ->get();
    
        // Debugging
        \Log::info('Syarat Adm Keu Data', ['data' => $syaratCetak->toArray()]);
    
        if ($syaratCetak->isEmpty()) {
            return response()->json(['message' => 'Data not found'], 404);
        }
    
        return response()->json(['SyaratCetak' => $syaratCetak], 200);
    }

}
