<?php

namespace App\Http\Controllers;

use App\Models\PembimbingPejabatAkademik;
use Illuminate\Http\Request;
use DB; // Pastikan ini ditambahkan

class PembimbingPejabatAkademikController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function PembimbingAkademik($namaUser)
    {
        // Retrieve pembimbing akademik data for a specific mahasiswa
        $pembimbingAkademikData = DB::table('t_dosen_wali as a')
            ->select(
                'a.id',
                'a.nidn',
                'b.nama as nama_dosen',
                'a.nim'
            )
            ->join('m_dosen as b', 'a.nidn', '=', 'b.nidn')
            ->join('m_mahasiswa as c', 'a.nim', '=', 'c.nim')
            ->where('a.nim', $namaUser)
            ->get();
        
        // Debugging
        \Log::info('Pembimbing Akademik Data for NIM: ' . $namaUser, ['data' => $pembimbingAkademikData->toArray()]);
        
        if ($pembimbingAkademikData->isEmpty()) {
            return response()->json(['message' => 'Data not found'], 404);
        }
    
        return response()->json($pembimbingAkademikData, 200);
    }

    
    public function PejabatAkademik()
    {
        // Retrieve data for pejabat akademik using INNER JOIN and WHERE IN
        $pejabatAkademikData = DB::table('m_user as a')
            ->select(
                'a.id_user',
                'a.nama',
                'b.group_id',
                'b.group_name'
            )
            ->join('m_group as b', function($join) {
                $join->on('a.group_id', '=', 'b.group_id')
                     ->on('a.id_company', '=', 'b.id_identitas');
            })
            ->whereIn('a.group_id', ['4', '15', '16', '39'])  // Filter using WHERE IN clause
            ->get();
        
        // Log the data for debugging purposes
        \Log::info('Fetching Pejabat Akademik Data', ['data' => $pejabatAkademikData->toArray()]);
        
        // Check if data exists
        if ($pejabatAkademikData->isEmpty()) {
            return response()->json(['message' => 'Data not found'], 404);
        }
    
        // Return the data as JSON
        return response()->json($pejabatAkademikData, 200);
    }







}
