<?php

namespace App\Http\Controllers;

use App\Models\MateriPerkuliahan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use Illuminate\Support\Facades\DB;

class MateriPerkuliahanController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    // Menampilkan MateriPerkuliahan berdasarkan NIM
    public function show($id)
    {
        $data = MateriPerkuliahan::select([
                't_materi_kuliah_dosen.id',
                't_materi_kuliah_dosen.kd_tahun_ajar',
                't_materi_kuliah_dosen.kd_semester',
                't_materi_kuliah_dosen.kd_jurusan',
                't_materi_kuliah_dosen.kd_matakuliah',
                't_materi_kuliah_dosen.keterangan',
                't_materi_kuliah_dosen.gambar',
                't_materi_kuliah_dosen.file',
                't_materi_kuliah_dosen.keydata',
                't_materi_kuliah_dosen.dibaca',
                't_materi_kuliah_dosen.nidn',
                't_materi_kuliah_dosen.tgl_input',
                'm_tahun_ajar.tahun_ajar',
                'm_semester.semester',
                'm_jurusan.jurusan',
                'm_fakultas.fakultas',
                'm_dosen.nama',
                'm_matakuliah.matakuliah',
                'm_kelas_detail.nim'
            ])
            ->join('m_tahun_ajar', 't_materi_kuliah_dosen.kd_tahun_ajar', '=', 'm_tahun_ajar.kd_tahun_ajar')
            ->join('m_semester', 't_materi_kuliah_dosen.kd_semester', '=', 'm_semester.kd_semester')
            ->join('m_jurusan', 't_materi_kuliah_dosen.kd_jurusan', '=', 'm_jurusan.kd_jurusan')
            ->join('m_fakultas', 'm_jurusan.kd_fakultas', '=', 'm_fakultas.kd_fakultas')
            ->join('m_dosen', 't_materi_kuliah_dosen.nidn', '=', 'm_dosen.nidn')
            ->join('m_user', 'm_dosen.nidn', '=', 'm_user.nidn')
            ->leftJoin('m_matakuliah', 't_materi_kuliah_dosen.kd_matakuliah', '=', 'm_matakuliah.kd_matakuliah')
            ->join('kelas_perkuliahan', function ($join) {
                $join->on('t_materi_kuliah_dosen.kd_jurusan', '=', 'kelas_perkuliahan.kd_jurusan')
                    ->on('t_materi_kuliah_dosen.kd_tahun_ajar', '=', 'kelas_perkuliahan.kd_tahun_ajar')
                    ->on('t_materi_kuliah_dosen.kd_semester', '=', 'kelas_perkuliahan.kd_semester')
                    ->on('t_materi_kuliah_dosen.kd_matakuliah', '=', 'kelas_perkuliahan.kd_matakuliah')
                    ->on('t_materi_kuliah_dosen.nidn', '=', 'kelas_perkuliahan.nidn');
            })
            ->join('m_kelas_detail', function ($join) use ($id) {
                $join->on('t_materi_kuliah_dosen.kd_jurusan', '=', 'm_kelas_detail.kd_jurusan')
                    ->on('t_materi_kuliah_dosen.kd_tahun_ajar', '=', 'm_kelas_detail.kd_tahun_ajar')
                    ->on('t_materi_kuliah_dosen.kd_semester', '=', 'm_kelas_detail.kd_semester')
                    ->where('m_kelas_detail.nim', $id);
            })
            ->get();
    
        if ($data->isEmpty()) {
            return response()->json(['message' => 'Data not found'], 404);
        }
    
        return response()->json($data);
    }

}
