<?php

namespace App\Http\Controllers;

use App\Models\KomponenBiayaKuliah;
use Illuminate\Http\Request;
use Validator;

class KomponenBiayaKuliahController extends Controller
{<?php

namespace App\Http\Controllers;

use App\Models\KomponenBiayaKuliah;
use Illuminate\Http\Request;

class BiayaKuliahController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function komponenbiayakuliah($kd_jurusan = null, $kd_semester = null, $kd_biaya = null, $kd_tahun_ajar = null)
    {
        // Log the values before using them
        \Log::info('kd_jurusan: ' . $kd_jurusan);
        \Log::info('kd_semester: ' . $kd_semester);
        \Log::info('kd_biaya: ' . $kd_biaya);
        \Log::info('kd_tahun_ajar: ' . $kd_tahun_ajar);

        // Initialize the query
        $query = KomponenBiayaKuliah::query();

        if ($kd_jurusan) {
            $query->where('kd_jurusan', $kd_jurusan);
        }

        if ($kd_semester) {
            $query->where('kd_semester', $kd_semester);
        }

        if ($kd_biaya) {
            $query->where('kd_biaya', $kd_biaya);
        }

        if ($kd_tahun_ajar) {
            $query->where('tgl_berlaku', $kd_tahun_ajar);
        }

        $komponenBiayaKuliahData = $query->get();

        // Check if data is found
        if ($komponenBiayaKuliahData->isEmpty()) {
            return response()->json(['message' => 'Data not found'], 404);
        }

        return response()->json($komponenBiayaKuliahData, 200);
    }
}
}
