<?php

namespace App\Http\Controllers;

use App\Models\KelasKuliah;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use Illuminate\Support\Facades\DB;

class KelasKuliahController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function index()
    {
        // Mengambil semua data KRS beserta relasinya
        $kelaskuliah = KelasKuliah::with(['jurusan', 'tahun_ajar', 'semester', 'kelas'])->get();

        return response()->json($kelaskuliah);
    }

    // Mendapatkan data KRS berdasarkan ID
    public function show($id)
    {
        // Mencari data KRS berdasarkan NIM
        $kelaskuliah = KelasKuliah::with(['jurusan', 'tahun_ajar', 'semester', 'kelas'])
                        ->where('nim', $id)
                        ->first();
    
        if (!$kelaskuliah) {
            return response()->json(['message' => 'Data tidak ditemukan'], 404);
        }
    
        return response()->json($kelaskuliah);
    }


    // Menyimpan data KRS baru
    public function store(Request $request)
    {
        // Validasi input
        $this->validate($request, [
            'kd_jurusan' => 'required',
            'kd_tahun_ajar' => 'required',
            'kd_semester' => 'required',
            'kd_kelas' => 'required',
            'kd_matakuliah' => 'required',
            'kd_hari' => 'required',
            'jam' => 'required',
            'jam_selesai' => 'required',
        ]);

        // Menyimpan data baru
        $kelaskuliah = KelasKuliah::create($request->all());

        return response()->json($kelaskuliah, 201);
    }

    // Memperbarui data KRS
    public function update(Request $request, $id)
    {
        // Mencari data KRS berdasarkan ID
        $kelaskuliah = KelasKuliah::find($id);

        if (!$kelaskuliah) {
            return response()->json(['message' => 'Data tidak ditemukan'], 404);
        }

        // Validasi input
        $this->validate($request, [
            'kd_jurusan' => 'required',
            'kd_tahun_ajar' => 'required',
            'kd_semester' => 'required',
            'kd_kelas' => 'required',
            'kd_matakuliah' => 'required',
            'kd_hari' => 'required',
            'jam' => 'required',
            'jam_selesai' => 'required',
        ]);

        // Memperbarui data
        $kelaskuliah->update($request->all());

        return response()->json($kelaskuliah);
    }

    // Menghapus data KRS
    public function destroy($id)
    {
        // Mencari data KRS berdasarkan ID
        $kelaskuliah = KelasKuliah::find($id);

        if (!$kelaskuliah) {
            return response()->json(['message' => 'Data tidak ditemukan'], 404);
        }

        // Menghapus data
        $kelaskuliah->delete();

        return response()->json(['message' => 'Data berhasil dihapus']);
    }
}
