<?php

namespace App\Http\Controllers;

use App\Models\Identitas;
use Illuminate\Http\Request;
use Validator;

class IdentitasController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }

    // Menampilkan semua data identitas
    public function index()
    {
        $identitas = Identitas::all();
        return response()->json($identitas);
    }

    // Menyimpan data identitas baru
    public function store(Request $request)
    {
        // Anda bisa menambahkan validasi di sini jika diperlukan
        $identitas = Identitas::create($request->all());
        return response()->json($identitas, 201);
    }

    // Menampilkan data identitas berdasarkan ID
    public function show($id)
    {
        $identitas = Identitas::findOrFail($id);
        return response()->json($identitas);
    }

    // Mengupdate data identitas berdasarkan ID
    public function update(Request $request, $id)
    {
        $identitas = Identitas::findOrFail($id);
        $identitas->update($request->all());
        return response()->json($identitas, 200);
    }

    // Menghapus data identitas berdasarkan ID
    public function destroy($id)
    {
        $identitas = Identitas::findOrFail($id);
        $identitas->delete();
        return response()->json(null, 204);
    }
}
