<?php

namespace App\Http\Controllers;

use App\Models\GroupAkses;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use Illuminate\Support\Facades\DB;

class GroupAksesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function index(Request $request)
    {
        $groupakses = GroupAkses::all();

        return response()->json($groupakses);
    }
    
    public function show($id)
    {
        $groupakses = GroupAkses::find($id);
        
        if (!$groupakses){
            return response()->json(['message' => 'Data not found'], 404);
        }
        
        return response()->json(['groupakses' => $groupakses]);
    }

}
