<?php

namespace App\Http\Controllers;

use App\Models\Biaya;
use Illuminate\Http\Request;

class BiayaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function show($id)
    {
        // Mengambil data biaya berdasarkan kd_biaya
        $biayaData = Biaya::where('kd_biaya', $id)->first(); // Menggunakan first() untuk mendapatkan satu record

        if (!$biayaData) {
            return response()->json(['message' => 'Data not found'], 404);
        }

        return response()->json($biayaData);
    }
}
